/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.service.serviceaction.repair;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.EventLog;
import com.ibm.hwmca.fw.pa.persist.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.pa.persist.ProblemPersistenceException;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.problem.ProblemNotRegisteredException;
import com.ibm.hwmca.fw.pa.problem.history.HistoryEntry;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElement;
import com.ibm.hwmca.fw.service.managedsystem.fru.Fru;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionType;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.pa.util.ProblemDataDescriptor;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class PIEndOfCall {
    private static final String TRACE_MASKT = "XRVXEOCT";
    private static final String TRACE_MASKF = "XRVXEOCF";
    private static final String TRACE_MASKD = "XRVXEOCD";
    private static String name;
    private static String location;

    public static void endOfCallProcessing(Map userData) {
        Trace.trace(TRACE_MASKD, "->PIEndOfCall::endOfCallProcessing");
        ProblemDataDescriptor pdd = new ProblemDataDescriptor();
        CommonProblem problem = (CommonProblem)userData.get("PROBLEM");
        if (PIEndOfCall.buildEocFile(userData)) {
            pdd.setName(name);
            pdd.setLocation(location);
            pdd.setCallHomeCandidate(true);
            problem.addProblemDataSet(pdd);
            try {
                ProblemManager.getProblemManager().changed(problem);
            }
            catch (ProblemNotRegisteredException e) {
                return;
            }
            catch (PersistenceNotInitializedException e) {
                return;
            }
            catch (ProblemPersistenceException e) {
                return;
            }
        }
        Trace.trace(TRACE_MASKD, "<-PIEndOfCall::endOfCallProcessing");
    }

    public void PIEndOfCall() {
    }

    private static boolean buildEocFile(Map userData) {
        List reseatedFrus;
        Map fruProps;
        Iterator iterator;
        DataOutputStream outputStream;
        Trace.trace(TRACE_MASKT, "-> PIEndOfCall::buildEocFile()");
        CommonProblem p = (CommonProblem)userData.get("PROBLEM");
        name = "eoc";
        String servActType = (String)userData.get("rvType");
        String machineType = null;
        String machineModel = null;
        String machineSerial = null;
        String uniqueKey = p.getUniqueKey();
        if (servActType.equals(ServiceActionType.REPAIR_PROBLEM.getValue()) || servActType.equals("OPEN_PROBLEM")) {
            Trace.trace(TRACE_MASKF, "EOC get MTMS from failing system");
            PASystem pas = p.getFailingSystem();
            if (pas != null) {
                machineType = pas.getMachineType();
            }
            name = machineType != null ? name + machineType : name + "T";
            if (pas != null) {
                machineModel = pas.getMachineModel();
            }
            name = machineModel != null ? name + machineModel : name + "M";
            if (pas != null) {
                machineSerial = pas.getMachineSerial();
            }
            name = machineSerial != null ? name + machineSerial : name + "S";
        } else {
            Trace.trace(TRACE_MASKF, "EOC get MTMS from map");
            machineType = (String)userData.get("MANAGED_SYSTEM_TYPE");
            machineModel = (String)userData.get("MANAGED_SYSTEM_MODEL");
            machineSerial = (String)userData.get("MANAGED_SYSTEM_SERIAL");
            name = machineType != null ? name + machineType : name + "T";
            name = machineModel != null ? name + machineModel : name + "M";
            name = machineSerial != null ? name + machineSerial : name + "S";
        }
        name = uniqueKey != null ? name + uniqueKey : name + "K";
        name = name + ".dat";
        Trace.trace(TRACE_MASKF, "EOC file name is " + name);
        try {
            location = BaseFileControl.getFilePath(name);
        }
        catch (HException e) {
            return false;
        }
        String fileName = location = location + name;
        Trace.trace(TRACE_MASKF, "EOC data file is " + fileName);
        try {
            FileUtilities.delete(fileName);
        }
        catch (FileNotFoundException e) {
            Trace.trace(TRACE_MASKF, "EOC data file didn't exist, continue");
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException deleting file, return false");
            return false;
        }
        Trace.trace(TRACE_MASKF, "Existing EOC data file deleted OK or didn't exist");
        try {
            outputStream = new DataOutputStream(new FileOutputStream(fileName));
        }
        catch (FileNotFoundException e) {
            Trace.trace(TRACE_MASKF, "Error creating EOC data file stream, return false");
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC data file stream created OK");
        int eocVersion = 10;
        try {
            outputStream.writeShort(eocVersion);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing version,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC version written OK");
        long errorTod = 0L;
        Date tempDate = new Date();
        GregorianCalendar errorCal = new GregorianCalendar();
        if (servActType.equals(ServiceActionType.REPAIR_PROBLEM.getValue()) || servActType.equals("OPEN_PROBLEM")) {
            Trace.trace(TRACE_MASKF, "EOC get timestamp from problem");
            try {
                errorCal.setTime(((EventLog)p.getPrimaryDataEvent().getData()).getTimestamp());
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "EOC exception getting timestamp from problem, use current TOD");
                errorCal.setTime(tempDate);
            }
        }
        errorTod = errorCal.getTimeInMillis();
        try {
            outputStream.writeLong(errorTod);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing errorTod, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC errorTod written OK");
        List historyList = p.getServiceHistory().getHistory();
        HistoryEntry entry = new HistoryEntry();
        errorCal.setTime(tempDate);
        if (servActType.equals(ServiceActionType.REPAIR_PROBLEM.getValue()) || servActType.equals("OPEN_PROBLEM")) {
            Trace.trace(TRACE_MASKF, "EOC get reported to customer timestamp from problem");
            iterator = historyList.iterator();
            while (iterator.hasNext()) {
                try {
                    entry = (HistoryEntry)iterator.next();
                }
                catch (NoSuchElementException e) {
                    Trace.trace(TRACE_MASKF, "NoSuchElementException searching Service History list,return false");
                    return false;
                }
                if (entry.getHistory() != 2) continue;
                errorCal.setTime(entry.getDate());
                break;
            }
        } else {
            Trace.trace(TRACE_MASKF, "EOC not a repair problem, use current TOD");
        }
        errorTod = errorCal.getTimeInMillis();
        try {
            outputStream.writeLong(errorTod);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing reported to customer TOD, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC reported to customer TOD written OK");
        errorCal.setTime(tempDate);
        if (servActType.equals(ServiceActionType.REPAIR_PROBLEM.getValue()) || servActType.equals("OPEN_PROBLEM")) {
            Trace.trace(TRACE_MASKF, "EOC get reported to customer timestamp from problem");
            iterator = historyList.iterator();
            while (iterator.hasNext()) {
                try {
                    entry = (HistoryEntry)iterator.next();
                }
                catch (NoSuchElementException e) {
                    Trace.trace(TRACE_MASKF, "NoSuchElementException searching Service History list,return false");
                    return false;
                }
                if (entry.getHistory() != 3) continue;
                errorCal.setTime(entry.getDate());
                break;
            }
        }
        errorTod = errorCal.getTimeInMillis();
        try {
            outputStream.writeLong(errorTod);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing reported to service TOD, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC reported to service TOD written OK");
        errorCal.setTime(tempDate);
        iterator = historyList.iterator();
        while (iterator.hasNext()) {
            try {
                entry = (HistoryEntry)iterator.next();
            }
            catch (NoSuchElementException e) {
                Trace.trace(TRACE_MASKF, "NoSuchElementException searching Service History list,return false");
                return false;
            }
            if (entry.getHistory() != 4) continue;
            errorCal.setTime(entry.getDate());
            break;
        }
        errorTod = errorCal.getTimeInMillis();
        try {
            outputStream.writeLong(errorTod);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing repair started TOD, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC repair started TOD written OK");
        errorTod = 0L;
        iterator = historyList.iterator();
        while (iterator.hasNext()) {
            try {
                entry = (HistoryEntry)iterator.next();
            }
            catch (NoSuchElementException e) {
                Trace.trace(TRACE_MASKF, "NoSuchElementException searching Service History list,return false");
                return false;
            }
            if (entry.getHistory() != 5) continue;
            errorCal.setTime(entry.getDate());
            errorTod = errorCal.getTimeInMillis();
            break;
        }
        try {
            outputStream.writeLong(errorTod);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing repair suspended TOD, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC repair suspended TOD written OK");
        errorTod = 0L;
        iterator = historyList.iterator();
        while (iterator.hasNext()) {
            try {
                entry = (HistoryEntry)iterator.next();
            }
            catch (NoSuchElementException e) {
                Trace.trace(TRACE_MASKF, "NoSuchElementException searching Service History list,return false");
                return false;
            }
            if (entry.getHistory() != 8) continue;
            errorCal.setTime(entry.getDate());
            errorTod = errorCal.getTimeInMillis();
            break;
        }
        try {
            outputStream.writeLong(errorTod);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing repair resumed TOD, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC repair resumed TOD written OK");
        errorCal.setTime(tempDate);
        iterator = historyList.iterator();
        while (iterator.hasNext()) {
            try {
                entry = (HistoryEntry)iterator.next();
            }
            catch (NoSuchElementException e) {
                Trace.trace(TRACE_MASKF, "NoSuchElementException searching Service History list,return false");
                return false;
            }
            if (entry.getHistory() != 9) continue;
            errorCal.setTime(entry.getDate());
            break;
        }
        errorTod = errorCal.getTimeInMillis();
        try {
            outputStream.writeLong(errorTod);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing repair ended TOD, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC repair ended TOD written OK");
        Integer Pn = new Integer(p.getProblemNumber());
        String problemNumber = Pn.toString();
        short fieldSize = (short)problemNumber.length();
        try {
            outputStream.writeShort(fieldSize);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing problem number field size, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC problem number field size written OK");
        try {
            outputStream.writeBytes(problemNumber);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing problemNumber, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC problemNumber written OK");
        if (machineType == null) {
            machineType = "_TYPE_";
        }
        fieldSize = (short)machineType.length();
        try {
            outputStream.writeShort(fieldSize);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing machine type field size, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC machine type field size written OK");
        try {
            outputStream.writeBytes(machineType);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing machineType,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC machineType written OK");
        if (machineModel == null) {
            machineModel = "_MODEL_";
        }
        fieldSize = (short)machineModel.length();
        try {
            outputStream.writeShort(fieldSize);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing machine model field size, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC machine model field size written OK");
        try {
            outputStream.writeBytes(machineModel);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing machineModel,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC machineModel written OK");
        if (machineSerial == null) {
            machineSerial = "_SERIAL_";
        }
        fieldSize = (short)machineSerial.length();
        try {
            outputStream.writeShort(fieldSize);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing machine serial field size, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC machine type field size written OK");
        try {
            outputStream.writeBytes(machineSerial);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing systemSerial,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC machineSerial written OK");
        String refcode = p.getRefcode();
        if (refcode == null) {
            refcode = "_SRC_";
        }
        fieldSize = (short)refcode.length();
        try {
            outputStream.writeShort(fieldSize);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing SRC field size, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC SRC field size written OK");
        try {
            outputStream.writeBytes(refcode);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing refcode,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC refcode written OK");
        String extension = p.getExtension();
        if (extension == null) {
            extension = "_EXT_";
        }
        fieldSize = (short)extension.length();
        try {
            outputStream.writeShort(fieldSize);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing extension field size, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC extension field size written OK");
        try {
            outputStream.writeBytes(extension);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing extension,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC extension written OK");
        String pmh = p.getPMH();
        if (pmh == null) {
            pmh = "_PMH_";
        }
        fieldSize = (short)pmh.length();
        try {
            outputStream.writeShort(fieldSize);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing PMH field size, return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC PMH field size written OK");
        try {
            outputStream.writeBytes(pmh);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException writing pmh,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC pmh written OK");
        List exchangedFrus = (List)userData.get("EXCHANGED_FRUS");
        if (exchangedFrus != null) {
            Iterator partIterator = exchangedFrus.iterator();
            while (partIterator.hasNext()) {
                try {
                    Object o = partIterator.next();
                    if (o instanceof ServiceableElement.PersistentDataImpl) {
                        ServiceableElement.PersistentDataImpl fruPDI = (ServiceableElement.PersistentDataImpl)o;
                        fruProps = fruPDI.properties;
                    } else {
                        fruProps = ((Fru)o).getProperties();
                    }
                }
                catch (NoSuchElementException e) {
                    Trace.trace(TRACE_MASKF, "NoSuchElementException searching FRU list,return false");
                    return false;
                }
                try {
                    outputStream.writeBytes("_FRU_");
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing _FRU_, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC removed _FRU_ written OK");
                try {
                    outputStream.writeBytes("M");
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing frutype, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC frutype M written OK");
                String physicalLocation = (String)fruProps.get("LOCATION");
                if (physicalLocation == null) {
                    physicalLocation = "_NO_LOCATION_";
                }
                fieldSize = (short)physicalLocation.length();
                try {
                    outputStream.writeShort(fieldSize);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing physicalLocation field size, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC physicalLocation field size written OK");
                Trace.trace(TRACE_MASKF, "EOC writing location " + physicalLocation);
                try {
                    outputStream.writeBytes(physicalLocation);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing physicalLocation,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC physicalLocation written OK");
                String oldPartNumber = (String)fruProps.get("OLD_PART_NUM");
                if (oldPartNumber == null) {
                    oldPartNumber = "_NO_OLD_PN_";
                }
                fieldSize = (short)oldPartNumber.length();
                try {
                    outputStream.writeShort(fieldSize);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing oldPartNumber field size, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC oldPartNumber field size written OK");
                Trace.trace(TRACE_MASKF, "EOC old part number is " + oldPartNumber);
                try {
                    outputStream.writeBytes(oldPartNumber);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing oldPartNumber,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC oldPartNumber written OK");
                String oldSerialNumber = (String)fruProps.get("OLD_SERIAL_NUM");
                if (oldSerialNumber == null) {
                    oldSerialNumber = "_NO_OLD_SN_";
                }
                fieldSize = (short)oldSerialNumber.length();
                try {
                    outputStream.writeShort(fieldSize);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing oldSerialNumber field size, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC oldSerialNumber field size written OK");
                Trace.trace(TRACE_MASKF, "EOC old serial number is " + oldSerialNumber);
                try {
                    outputStream.writeBytes(oldSerialNumber);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing oldSerialNumber,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC oldSerialNumber written OK");
                String oldECNumber = (String)fruProps.get("OLD_EC_LEVEL");
                if (oldECNumber == null) {
                    oldECNumber = "_NO_OLD_EC_";
                }
                fieldSize = (short)oldECNumber.length();
                try {
                    outputStream.writeShort(fieldSize);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing old EC number field size, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC old EC number field size written OK");
                Trace.trace(TRACE_MASKF, "EOC writing old EC number " + oldECNumber);
                try {
                    outputStream.writeBytes(oldECNumber);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing oldECNumber,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC oldECNumber written OK");
                String ccin = (String)fruProps.get("CCIN");
                if (ccin == null) {
                    ccin = "_NO_CCIN_";
                }
                Trace.trace(TRACE_MASKF, "EOC writing ccin " + ccin);
                try {
                    outputStream.writeBytes(ccin);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing ccin,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC ccin written OK");
                try {
                    outputStream.writeBytes("_FRU_");
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing new _FRU_, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC new _FRU_ written OK");
                try {
                    outputStream.writeBytes("N");
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing frutype, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC frutype N written OK");
                fieldSize = (short)physicalLocation.length();
                try {
                    outputStream.writeShort(fieldSize);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing physicalLocation field size, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC physicalLocation field size written OK");
                Trace.trace(TRACE_MASKF, "EOC writing location " + physicalLocation);
                try {
                    outputStream.writeBytes(physicalLocation);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing physicalLocation,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC physicalLocation written OK");
                String newPartNumber = (String)fruProps.get("OLD_PART_NUM");
                if (newPartNumber == null) {
                    newPartNumber = "_NO_NEW_PN_";
                }
                fieldSize = (short)newPartNumber.length();
                try {
                    outputStream.writeShort(fieldSize);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing newPartNumber field size, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC newPartNumber field size written OK");
                Trace.trace(TRACE_MASKF, "EOC new part number is " + newPartNumber);
                try {
                    outputStream.writeBytes(newPartNumber);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing newPartNumber,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC newPartNumber written OK");
                String newSerialNumber = (String)fruProps.get("SERIAL_NUM");
                if (newSerialNumber == null) {
                    newSerialNumber = "_NO_NEW_SN_";
                }
                fieldSize = (short)newSerialNumber.length();
                try {
                    outputStream.writeShort(fieldSize);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing newSerialNumber field size, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC newSerialNumber field size written OK");
                Trace.trace(TRACE_MASKF, "EOC new serial number is " + newSerialNumber);
                try {
                    outputStream.writeBytes(newSerialNumber);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing newSerialNumber,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC newSerialNumber written OK");
                String newECNumber = (String)fruProps.get("EC_LEVEL");
                if (newECNumber == null) {
                    newECNumber = "_NO_NEW_EC_";
                }
                fieldSize = (short)newECNumber.length();
                try {
                    outputStream.writeShort(fieldSize);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing new EC number field size, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC new EC number field size written OK");
                Trace.trace(TRACE_MASKF, "EOC writing new EC number " + newECNumber);
                try {
                    outputStream.writeBytes(newECNumber);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing newECNumber,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC newECNumber written OK");
                Trace.trace(TRACE_MASKF, "EOC writing ccin " + ccin);
                try {
                    outputStream.writeBytes(ccin);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing ccin,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC ccin written OK");
            }
        }
        if ((reseatedFrus = (List)userData.get("RESEATED_FRUS")) != null) {
            Iterator partIterator = reseatedFrus.iterator();
            while (partIterator.hasNext()) {
                try {
                    Object o = partIterator.next();
                    if (o instanceof ServiceableElement.PersistentDataImpl) {
                        ServiceableElement.PersistentDataImpl fruPDI = (ServiceableElement.PersistentDataImpl)o;
                        fruProps = fruPDI.properties;
                    } else {
                        fruProps = ((Fru)o).getProperties();
                    }
                }
                catch (NoSuchElementException e) {
                    Trace.trace(TRACE_MASKF, "NoSuchElementException searching FRU list,return false");
                    return false;
                }
                try {
                    outputStream.writeBytes("_FRU_");
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing _FRU_, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC removed _FRU_ written OK");
                try {
                    outputStream.writeBytes("R");
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing frutype, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC frutype R written OK");
                String physicalLocation = (String)fruProps.get("LOCATION");
                if (physicalLocation == null) {
                    physicalLocation = "_NO_LOCATION_";
                }
                fieldSize = (short)physicalLocation.length();
                try {
                    outputStream.writeShort(fieldSize);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing physicalLocation field size, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC physicalLocation field size written OK");
                Trace.trace(TRACE_MASKF, "EOC writing location " + physicalLocation);
                try {
                    outputStream.writeBytes(physicalLocation);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing physicalLocation,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC physicalLocation written OK");
                String oldPartNumber = (String)fruProps.get("OLD_PART_NUM");
                if (oldPartNumber == null) {
                    oldPartNumber = "_NO_OLD_PN_";
                }
                fieldSize = (short)oldPartNumber.length();
                try {
                    outputStream.writeShort(fieldSize);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing oldPartNumber field size, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC oldPartNumber field size written OK");
                Trace.trace(TRACE_MASKF, "EOC old part number is " + oldPartNumber);
                try {
                    outputStream.writeBytes(oldPartNumber);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing oldPartNumber,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC oldPartNumber written OK");
                String oldSerialNumber = (String)fruProps.get("OLD_SERIAL_NUM");
                if (oldSerialNumber == null) {
                    oldSerialNumber = "_NO_OLD_SN_";
                }
                fieldSize = (short)oldSerialNumber.length();
                try {
                    outputStream.writeShort(fieldSize);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing oldSerialNumber field size, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC oldSerialNumber field size written OK");
                Trace.trace(TRACE_MASKF, "EOC old serial number is " + oldSerialNumber);
                try {
                    outputStream.writeBytes(oldSerialNumber);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing oldSerialNumber,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC oldSerialNumber written OK");
                String oldECNumber = (String)fruProps.get("OLD_EC_LEVEL");
                if (oldECNumber == null) {
                    oldECNumber = "_NO_OLD_EC_";
                }
                fieldSize = (short)oldECNumber.length();
                try {
                    outputStream.writeShort(fieldSize);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing old EC number field size, return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC old EC number field size written OK");
                Trace.trace(TRACE_MASKF, "EOC writing old EC number " + oldECNumber);
                try {
                    outputStream.writeBytes(oldECNumber);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing oldECNumber,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC oldECNumber written OK");
                String ccin = (String)fruProps.get("CCIN");
                if (ccin == null) {
                    ccin = "_NO_CCIN_";
                }
                Trace.trace(TRACE_MASKF, "EOC writing ccin " + ccin);
                try {
                    outputStream.writeBytes(ccin);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "IOException writing ccin,return false");
                    try {
                        outputStream.close();
                    }
                    catch (IOException ee) {
                        return false;
                    }
                    return false;
                }
                Trace.trace(TRACE_MASKF, "EOC ccin written OK");
            }
        }
        try {
            outputStream.flush();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException flushing file,return false");
            try {
                outputStream.close();
            }
            catch (IOException ee) {
                return false;
            }
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC file flushed OK");
        try {
            outputStream.close();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "IOException closing file,return false");
            return false;
        }
        Trace.trace(TRACE_MASKF, "EOC file closed OK");
        return true;
    }

    private void setFileName(String inputName) {
        name = inputName;
    }

    private String getFileName() {
        return name;
    }

    private void setLocation(String inputName) {
        location = inputName;
    }

    private String getFileLocation() {
        return location;
    }
}

